<?php
/**
 * MAXEDR10 - MAX ERP 10
 * Autoloader simples
 * 
 * Carrega automaticamente as classes do sistema
 */

spl_autoload_register(function ($class) {
    // Namespace base do projeto
    $prefix = 'Maxedr10\\';
    
    // Diretório base onde as classes estão
    $base_dir = __DIR__ . '/';
    
    // Verifica se a classe usa o namespace do projeto
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    // Pega o nome relativo da classe
    $relative_class = substr($class, $len);
    
    // Substitui o namespace por estrutura de diretórios
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    
    // Se o arquivo existe, inclui
    if (file_exists($file)) {
        require $file;
    }
});
