<?php
/**
 * MAXEDR10 - MAX ERP 10
 * Model: Usuario
 */

namespace Maxedr10\Models;

use Maxedr10\Database\Database;

class Usuario {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance();
    }
    
    /**
     * Autentica um usuário por e-mail e senha
     */
    public function autenticar($email, $senha) {
        $sql = "SELECT u.*, e.nome as empresa_nome 
                FROM usuarios u 
                INNER JOIN empresas e ON u.empresa_id = e.id
                WHERE u.email = ? AND u.ativo = 1";
        
        $usuario = $this->db->queryOne($sql, [$email]);
        
        if ($usuario && password_verify($senha, $usuario['senha'])) {
            // Remove a senha do retorno
            unset($usuario['senha']);
            return $usuario;
        }
        
        return false;
    }
    
    /**
     * Busca um usuário por ID
     */
    public function buscarPorId($id) {
        $sql = "SELECT u.*, e.nome as empresa_nome 
                FROM usuarios u 
                INNER JOIN empresas e ON u.empresa_id = e.id
                WHERE u.id = ?";
        
        $usuario = $this->db->queryOne($sql, [$id]);
        
        if ($usuario) {
            unset($usuario['senha']);
        }
        
        return $usuario;
    }
    
    /**
     * Lista todos os usuários de uma empresa
     */
    public function listarPorEmpresa($empresaId) {
        $sql = "SELECT id, nome, email, nivel, ativo, created_at 
                FROM usuarios 
                WHERE empresa_id = ? 
                ORDER BY nome";
        
        return $this->db->query($sql, [$empresaId]);
    }
}
