<?php
/**
 * MAXEDR10 - MAX ERP 10
 * Header Include
 */

// Garantir que o usuário está autenticado
requireAuth();

$user = getAuthUser();
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'MAX ERP 10'; ?> - MAXEDR10</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/assets/css/style.css">
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="d-flex align-items-center gap-3">
            <button class="menu-toggle" onclick="toggleSidebar()">
                <i class="fas fa-bars"></i>
            </button>
            <div class="logo">
                <i class="fas fa-chart-line"></i> MAX ERP 10
            </div>
        </div>
        
        <div class="user-info">
            <span class="user-name">
                <i class="fas fa-user-circle"></i> <?php echo htmlspecialchars($user['nome']); ?>
            </span>
            <button class="btn btn-sm btn-danger" onclick="logout()">
                <i class="fas fa-sign-out-alt"></i> Sair
            </button>
        </div>
    </div>
