<?php
require_once __DIR__ . '/../config/config.php';
$pageTitle = 'Modelos de Contrato';
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-file-contract"></i> Modelos de Contrato</h2>
        <button class="btn btn-primary" onclick="novoModelo()"><i class="fas fa-plus"></i> Novo Modelo</button>
    </div>
    
    <div class="card mb-3" style="background: #e3f2fd;">
        <div class="card-body">
            <strong><i class="fas fa-info-circle"></i> TAGs Disponíveis:</strong><br>
            <code>{{nome}}</code> <code>{{cpf}}</code> <code>{{cnpj}}</code> <code>{{cpf_cnpj}}</code> <code>{{endereco}}</code> 
            <code>{{cidade}}</code> <code>{{estado}}</code> <code>{{telefone}}</code> <code>{{email}}</code> 
            <code>{{data_atual}}</code> <code>{{valor}}</code> <code>{{descricao_servico}}</code> <code>{{data_validade}}</code>
        </div>
    </div>
    
    <div class="row" id="listaModelos">
        <div class="col-12 text-center">Carregando...</div>
    </div>
</div>

<div class="modal" id="modalModelo">
    <div class="modal-content" style="max-width: 900px;">
        <div class="modal-header">
            <h5 id="modalTitulo">Novo Modelo</h5>
            <button class="close" onclick="fecharModal()">&times;</button>
        </div>
        <div class="modal-body">
            <form id="formModelo">
                <input type="hidden" id="modeloId">
                <div class="form-group">
                    <label class="form-label">Nome do Modelo *</label>
                    <input type="text" class="form-control" id="nome" required>
                </div>
                <div class="form-group">
                    <label class="form-label">Descrição</label>
                    <textarea class="form-control" id="descricao" rows="2"></textarea>
                </div>
                <div class="form-group">
                    <label class="form-label">Conteúdo HTML do Contrato *</label>
                    <textarea class="form-control" id="conteudo_html" rows="15" style="font-family: monospace;" required></textarea>
                    <small class="form-text text-muted">Use as TAGs disponíveis acima para personalizar o contrato</small>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="fecharModal()">Cancelar</button>
            <button class="btn btn-primary" onclick="salvarModelo()">Salvar</button>
        </div>
    </div>
</div>

<script>
async function carregarModelos() {
    try {
        const response = await fetch(`${API_URL}/contratos/modelos.php`);
        const data = await response.json();
        const container = document.getElementById('listaModelos');
        
        if (data.success && data.data.length > 0) {
            container.innerHTML = data.data.map(modelo => `
                <div class="col-md-6 mb-3">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">${modelo.nome}</h5>
                            <p class="card-text">${modelo.descricao || 'Sem descrição'}</p>
                            <p class="text-muted"><small>Criado em: ${formatDate(modelo.created_at)}</small></p>
                            <button class="btn btn-sm btn-primary" onclick="editarModelo(${modelo.id})">
                                <i class="fas fa-edit"></i> Editar
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="deletarModelo(${modelo.id})">
                                <i class="fas fa-trash"></i> Deletar
                            </button>
                        </div>
                    </div>
                </div>
            `).join('');
        } else {
            container.innerHTML = '<div class="col-12 text-center">Nenhum modelo encontrado</div>';
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function novoModelo() {
    document.getElementById('formModelo').reset();
    document.getElementById('modeloId').value = '';
    document.getElementById('modalTitulo').textContent = 'Novo Modelo';
    document.getElementById('modalModelo').classList.add('show');
}

async function editarModelo(id) {
    try {
        const response = await fetch(`${API_URL}/contratos/modelos.php?id=${id}`);
        const data = await response.json();
        
        if (data.success && data.data) {
            const m = data.data;
            document.getElementById('modeloId').value = m.id;
            document.getElementById('nome').value = m.nome;
            document.getElementById('descricao').value = m.descricao || '';
            document.getElementById('conteudo_html').value = m.conteudo_html;
            document.getElementById('modalTitulo').textContent = 'Editar Modelo';
            document.getElementById('modalModelo').classList.add('show');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function salvarModelo() {
    const id = document.getElementById('modeloId').value;
    const dados = {
        nome: document.getElementById('nome').value,
        descricao: document.getElementById('descricao').value,
        conteudo_html: document.getElementById('conteudo_html').value
    };
    
    try {
        const url = id ? `${API_URL}/contratos/modelos.php?id=${id}` : `${API_URL}/contratos/modelos.php`;
        const method = id ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
            method: method,
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(dados)
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            fecharModal();
            carregarModelos();
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function deletarModelo(id) {
    if (!confirmAction('Deseja deletar este modelo?')) return;
    
    try {
        const response = await fetch(`${API_URL}/contratos/modelos.php?id=${id}`, { method: 'DELETE' });
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            carregarModelos();
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function fecharModal() {
    document.getElementById('modalModelo').classList.remove('show');
}

document.addEventListener('DOMContentLoaded', carregarModelos);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
