<?php
require_once __DIR__ . '/../config/config.php';
$pageTitle = 'Gerar Contrato';
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';
?>

<div class="container-fluid">
    <h2 class="mb-4"><i class="fas fa-file-signature"></i> Gerar Contrato</h2>
    
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Dados do Contrato</div>
                <div class="card-body">
                    <form id="formGerar">
                        <div class="form-group">
                            <label class="form-label">Cliente *</label>
                            <select class="form-control" id="cliente_id" required>
                                <option value="">Selecione um cliente</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label">Modelo de Contrato *</label>
                            <select class="form-control" id="modelo_id" required>
                                <option value="">Selecione um modelo</option>
                            </select>
                        </div>
                        
                        <hr>
                        
                        <h6>Dados Adicionais</h6>
                        
                        <div class="form-group">
                            <label class="form-label">Valor do Contrato</label>
                            <input type="number" step="0.01" class="form-control" id="valor" placeholder="Ex: 5000.00">
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label">Descrição do Serviço</label>
                            <textarea class="form-control" id="descricao_servico" rows="3" placeholder="Ex: Desenvolvimento de sistema web"></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label">Data de Validade</label>
                            <input type="date" class="form-control" id="data_validade">
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fas fa-magic"></i> Gerar Contrato
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Prévia do Contrato</div>
                <div class="card-body" id="previsualizacao" style="max-height: 600px; overflow-y: auto; background: #f9f9f9;">
                    <p class="text-muted text-center">O contrato gerado será exibido aqui</p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Carregar clientes e modelos
async function carregarDados() {
    try {
        // Carregar clientes
        const responseClientes = await fetch(`${API_URL}/clientes/index.php`);
        const dataClientes = await responseClientes.json();
        
        const selectClientes = document.getElementById('cliente_id');
        if (dataClientes.success && dataClientes.data.length > 0) {
            dataClientes.data.forEach(cliente => {
                selectClientes.innerHTML += `<option value="${cliente.id}">${cliente.nome}</option>`;
            });
        }
        
        // Carregar modelos
        const responseModelos = await fetch(`${API_URL}/contratos/modelos.php`);
        const dataModelos = await responseModelos.json();
        
        const selectModelos = document.getElementById('modelo_id');
        if (dataModelos.success && dataModelos.data.length > 0) {
            dataModelos.data.forEach(modelo => {
                selectModelos.innerHTML += `<option value="${modelo.id}">${modelo.nome}</option>`;
            });
        }
    } catch (error) {
        console.error('Erro ao carregar dados:', error);
        showAlert('Erro ao carregar dados', 'danger');
    }
}

// Formulário de gerar contrato
document.getElementById('formGerar').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const dados = {
        cliente_id: document.getElementById('cliente_id').value,
        modelo_id: document.getElementById('modelo_id').value,
        valor: document.getElementById('valor').value,
        descricao_servico: document.getElementById('descricao_servico').value,
        data_validade: document.getElementById('data_validade').value
    };
    
    if (!dados.cliente_id || !dados.modelo_id) {
        showAlert('Selecione um cliente e um modelo de contrato', 'warning');
        return;
    }
    
    try {
        const response = await fetch(`${API_URL}/contratos/gerar.php`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(dados)
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert('Contrato gerado com sucesso!', 'success');
            
            // Exibir prévia do contrato
            document.getElementById('previsualizacao').innerHTML = data.conteudo_final;
            
            // Opção de imprimir
            setTimeout(() => {
                if (confirm('Deseja imprimir o contrato?')) {
                    const janela = window.open('', '_blank');
                    janela.document.write(data.conteudo_final);
                    janela.document.close();
                    janela.print();
                }
            }, 500);
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        console.error('Erro ao gerar contrato:', error);
        showAlert('Erro ao gerar contrato', 'danger');
    }
});

// Carregar dados ao iniciar
document.addEventListener('DOMContentLoaded', carregarDados);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
