<?php
require_once __DIR__ . '/../config/config.php';
$pageTitle = 'Clientes';
include __DIR__ . '/includes/header.php';
include __DIR__ . '/includes/sidebar.php';
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-users"></i> Clientes</h2>
        <button class="btn btn-primary" onclick="novoCliente()"><i class="fas fa-plus"></i> Novo Cliente</button>
    </div>
    
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>CPF/CNPJ</th>
                    <th>Telefone</th>
                    <th>E-mail</th>
                    <th>Cidade</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody id="tabelaClientes">
                <tr><td colspan="6" class="text-center">Carregando...</td></tr>
            </tbody>
        </table>
    </div>
</div>

<div class="modal" id="modalCliente">
    <div class="modal-content" style="max-width: 800px;">
        <div class="modal-header">
            <h5 id="modalTitulo">Novo Cliente</h5>
            <button class="close" onclick="fecharModal()">&times;</button>
        </div>
        <div class="modal-body">
            <form id="formCliente">
                <input type="hidden" id="clienteId">
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label class="form-label">Nome *</label>
                            <input type="text" class="form-control" id="nome" required>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label">Tipo</label>
                            <select class="form-control" id="tipo">
                                <option value="fisica">Pessoa Física</option>
                                <option value="juridica">Pessoa Jurídica</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label">CPF/CNPJ</label>
                            <input type="text" class="form-control" id="cpf_cnpj">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label">Telefone</label>
                            <input type="text" class="form-control" id="telefone">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label">E-mail</label>
                            <input type="email" class="form-control" id="email">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-8">
                        <div class="form-group">
                            <label class="form-label">Endereço</label>
                            <input type="text" class="form-control" id="endereco">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="form-label">Número</label>
                            <input type="text" class="form-control" id="numero">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="form-label">Cidade</label>
                            <input type="text" class="form-control" id="cidade">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="form-label">Estado</label>
                            <select class="form-control" id="estado">
                                <option value="">Selecione</option>
                                <option value="SP">SP</option>
                                <option value="RJ">RJ</option>
                                <option value="MG">MG</option>
                                <!-- Adicionar outros estados -->
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="form-label">CEP</label>
                            <input type="text" class="form-control" id="cep">
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" onclick="fecharModal()">Cancelar</button>
            <button class="btn btn-primary" onclick="salvarCliente()">Salvar</button>
        </div>
    </div>
</div>

<script>
async function carregarClientes() {
    try {
        const response = await fetch(`${API_URL}/clientes/index.php`);
        const data = await response.json();
        const tbody = document.getElementById('tabelaClientes');
        
        if (data.success && data.data.length > 0) {
            tbody.innerHTML = data.data.map(cliente => `
                <tr>
                    <td>${cliente.nome}</td>
                    <td>${cliente.cpf_cnpj || '-'}</td>
                    <td>${cliente.telefone || '-'}</td>
                    <td>${cliente.email || '-'}</td>
                    <td>${cliente.cidade || '-'}/${cliente.estado || '-'}</td>
                    <td>
                        <button class="btn btn-sm btn-primary" onclick="editarCliente(${cliente.id})"><i class="fas fa-edit"></i></button>
                        <button class="btn btn-sm btn-danger" onclick="deletarCliente(${cliente.id})"><i class="fas fa-trash"></i></button>
                    </td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="6" class="text-center">Nenhum cliente encontrado</td></tr>';
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function novoCliente() {
    document.getElementById('formCliente').reset();
    document.getElementById('clienteId').value = '';
    document.getElementById('modalTitulo').textContent = 'Novo Cliente';
    document.getElementById('modalCliente').classList.add('show');
}

async function editarCliente(id) {
    try {
        const response = await fetch(`${API_URL}/clientes/index.php?id=${id}`);
        const data = await response.json();
        
        if (data.success && data.data) {
            const c = data.data;
            document.getElementById('clienteId').value = c.id;
            document.getElementById('nome').value = c.nome;
            document.getElementById('tipo').value = c.tipo || 'fisica';
            document.getElementById('cpf_cnpj').value = c.cpf_cnpj || '';
            document.getElementById('telefone').value = c.telefone || '';
            document.getElementById('email').value = c.email || '';
            document.getElementById('endereco').value = c.endereco || '';
            document.getElementById('numero').value = c.numero || '';
            document.getElementById('cidade').value = c.cidade || '';
            document.getElementById('estado').value = c.estado || '';
            document.getElementById('cep').value = c.cep || '';
            document.getElementById('modalTitulo').textContent = 'Editar Cliente';
            document.getElementById('modalCliente').classList.add('show');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function salvarCliente() {
    const id = document.getElementById('clienteId').value;
    const dados = {
        nome: document.getElementById('nome').value,
        tipo: document.getElementById('tipo').value,
        cpf_cnpj: document.getElementById('cpf_cnpj').value,
        telefone: document.getElementById('telefone').value,
        email: document.getElementById('email').value,
        endereco: document.getElementById('endereco').value,
        numero: document.getElementById('numero').value,
        cidade: document.getElementById('cidade').value,
        estado: document.getElementById('estado').value,
        cep: document.getElementById('cep').value
    };
    
    try {
        const url = id ? `${API_URL}/clientes/index.php?id=${id}` : `${API_URL}/clientes/index.php`;
        const method = id ? 'PUT' : 'POST';
        
        const response = await fetch(url, {
            method: method,
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify(dados)
        });
        
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            fecharModal();
            carregarClientes();
        } else {
            showAlert(data.message, 'danger');
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

async function deletarCliente(id) {
    if (!confirmAction('Deseja deletar este cliente?')) return;
    
    try {
        const response = await fetch(`${API_URL}/clientes/index.php?id=${id}`, { method: 'DELETE' });
        const data = await response.json();
        
        if (data.success) {
            showAlert(data.message, 'success');
            carregarClientes();
        }
    } catch (error) {
        console.error('Erro:', error);
    }
}

function fecharModal() {
    document.getElementById('modalCliente').classList.remove('show');
}

document.addEventListener('DOMContentLoaded', carregarClientes);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
