<?php
/**
 * MAXEDR10 - MAX ERP 10
 * Arquivo de Configuração
 * 
 * Configurações de banco de dados e constantes do sistema
 */

// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'maxedr10');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Configurações do Sistema
define('BASE_URL', 'http://localhost/maxedr10/public');
define('API_URL', 'http://localhost/maxedr10/api');

// Timezone
date_default_timezone_set('America/Sao_Paulo');

// Configurações de Sessão
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
session_save_path(sys_get_temp_dir());

// Iniciar sessão se ainda não foi iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Configurações de Erro (desenvolvimento)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Headers para JSON (usar nas APIs)
function setJsonHeaders() {
    header('Content-Type: application/json; charset=utf-8');
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
}

// Função auxiliar para verificar autenticação
function isAuthenticated() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

// Função auxiliar para obter dados do usuário logado
function getAuthUser() {
    if (!isAuthenticated()) {
        return null;
    }
    
    return [
        'id' => $_SESSION['user_id'] ?? null,
        'nome' => $_SESSION['user_nome'] ?? null,
        'email' => $_SESSION['user_email'] ?? null,
        'empresa_id' => $_SESSION['empresa_id'] ?? null,
        'nivel' => $_SESSION['user_nivel'] ?? null
    ];
}

// Função para proteger páginas (redireciona para login se não autenticado)
function requireAuth() {
    if (!isAuthenticated()) {
        header('Location: ' . BASE_URL . '/index.php');
        exit;
    }
}
