<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Clientes
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Cliente;
use Maxedr10\Models\Contrato;

setJsonHeaders();

if (!isAuthenticated()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Não autenticado']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$user = getAuthUser();
$empresaId = $user['empresa_id'];

// Verificar se está buscando contratos de um cliente
$pathParts = explode('/', $_SERVER['REQUEST_URI']);
if (in_array('contratos', $pathParts) && $method === 'GET') {
    try {
        $clienteId = $_GET['cliente_id'] ?? null;
        
        if (!$clienteId) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID do cliente não informado']);
            exit;
        }
        
        $contratoModel = new Contrato();
        $contratos = $contratoModel->listarGerados($empresaId, $clienteId);
        
        echo json_encode(['success' => true, 'data' => $contratos]);
        exit;
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Erro no servidor: ' . $e->getMessage()]);
        exit;
    }
}

try {
    $clienteModel = new Cliente();
    
    if ($method === 'GET') {
        $id = $_GET['id'] ?? null;
        
        if ($id) {
            // Buscar um cliente específico
            $cliente = $clienteModel->buscarPorId($id, $empresaId);
            
            if ($cliente) {
                echo json_encode(['success' => true, 'data' => $cliente]);
            } else {
                http_response_code(404);
                echo json_encode(['success' => false, 'message' => 'Cliente não encontrado']);
            }
        } else {
            // Listar todos os clientes
            $filtros = ['nome' => $_GET['nome'] ?? null];
            $clientes = $clienteModel->listar($empresaId, $filtros);
            
            echo json_encode(['success' => true, 'data' => $clientes]);
        }
    }
    
    elseif ($method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data['nome'])) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Nome é obrigatório']);
            exit;
        }
        
        $data['empresa_id'] = $empresaId;
        $id = $clienteModel->criar($data);
        
        if ($id) {
            echo json_encode(['success' => true, 'message' => 'Cliente criado com sucesso', 'id' => $id]);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao criar cliente']);
        }
    }
    
    elseif ($method === 'PUT') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        $data = json_decode(file_get_contents('php://input'), true);
        
        if ($clienteModel->atualizar($id, $empresaId, $data)) {
            echo json_encode(['success' => true, 'message' => 'Cliente atualizado com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao atualizar cliente']);
        }
    }
    
    elseif ($method === 'DELETE') {
        $id = $_GET['id'] ?? null;
        
        if (!$id) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'ID não informado']);
            exit;
        }
        
        if ($clienteModel->deletar($id, $empresaId)) {
            echo json_encode(['success' => true, 'message' => 'Cliente deletado com sucesso']);
        } else {
            http_response_code(500);
            echo json_encode(['success' => false, 'message' => 'Erro ao deletar cliente']);
        }
    }
    
    else {
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Erro no servidor: ' . $e->getMessage()]);
}
