<?php
/**
 * MAXEDR10 - MAX ERP 10
 * API de Autenticação
 * 
 * Endpoints:
 * POST /api/auth/login.php
 * POST /api/auth/logout.php
 * GET /api/auth/me.php
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../src/autoload.php';

use Maxedr10\Models\Usuario;

setJsonHeaders();

// Verificar o método HTTP
$method = $_SERVER['REQUEST_METHOD'];

// Obter o endpoint chamado
$endpoint = basename($_SERVER['PHP_SELF'], '.php');

try {
    // ========== LOGIN ==========
    if ($endpoint === 'login' && $method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
        
        if (empty($data['email']) || empty($data['senha'])) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'E-mail e senha são obrigatórios'
            ]);
            exit;
        }
        
        $usuarioModel = new Usuario();
        $usuario = $usuarioModel->autenticar($data['email'], $data['senha']);
        
        if ($usuario) {
            // Salvar dados na sessão
            $_SESSION['user_id'] = $usuario['id'];
            $_SESSION['user_nome'] = $usuario['nome'];
            $_SESSION['user_email'] = $usuario['email'];
            $_SESSION['empresa_id'] = $usuario['empresa_id'];
            $_SESSION['user_nivel'] = $usuario['nivel'];
            
            echo json_encode([
                'success' => true,
                'message' => 'Login realizado com sucesso',
                'user' => $usuario
            ]);
        } else {
            http_response_code(401);
            echo json_encode([
                'success' => false,
                'message' => 'E-mail ou senha inválidos'
            ]);
        }
    }
    
    // ========== LOGOUT ==========
    elseif ($endpoint === 'logout' && $method === 'POST') {
        session_destroy();
        
        echo json_encode([
            'success' => true,
            'message' => 'Logout realizado com sucesso'
        ]);
    }
    
    // ========== ME (Usuário autenticado) ==========
    elseif ($endpoint === 'me' && $method === 'GET') {
        if (!isAuthenticated()) {
            http_response_code(401);
            echo json_encode([
                'success' => false,
                'message' => 'Não autenticado'
            ]);
            exit;
        }
        
        $user = getAuthUser();
        
        echo json_encode([
            'success' => true,
            'user' => $user
        ]);
    }
    
    // ========== MÉTODO NÃO PERMITIDO ==========
    else {
        http_response_code(405);
        echo json_encode([
            'success' => false,
            'message' => 'Método não permitido'
        ]);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro no servidor: ' . $e->getMessage()
    ]);
}
