# 🚀 MAXEDR10 - Guia Rápido de Instalação

## ⚡ Instalação Rápida (5 minutos)

### Passo 1: Configurar Banco de Dados

```bash
# 1. Criar banco de dados
mysql -u root -p
CREATE DATABASE maxedr10 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
exit;

# 2. Importar schema
cd /caminho/do/projeto/maxedr10
mysql -u root -p maxedr10 < database/schema.sql
```

### Passo 2: Configurar Sistema

Edite `config/config.php`:

```php
// Ajuste as credenciais do MySQL
define('DB_HOST', 'localhost');
define('DB_NAME', 'maxedr10');
define('DB_USER', 'root');
define('DB_PASS', 'SUA_SENHA_AQUI');

// Ajuste as URLs conforme sua instalação
define('BASE_URL', 'http://localhost/maxedr10/public');
define('API_URL', 'http://localhost/maxedr10/api');
```

### Passo 3: Acessar o Sistema

1. Abra seu navegador
2. Acesse: `http://localhost/maxedr10/public/index.php`
3. Faça login com:
   - **E-mail:** admin@demo.com
   - **Senha:** 123456

## 📋 O que foi criado?

### Backend (PHP 8+ / MySQL)

✅ **Arquitetura API-First**
- 21 endpoints REST funcionais
- Autenticação via sessão PHP
- Models com PDO e Prepared Statements
- Estrutura organizada em camadas

✅ **Módulo Financeiro Completo**
- Lançamentos financeiros (entradas/saídas)
- Categorias personalizáveis
- Contas a pagar e receber
- Dashboard com gráficos interativos
- Relatórios e filtros avançados

✅ **Módulo de Clientes**
- Cadastro completo
- Gestão de relacionamento
- Histórico integrado

✅ **Módulo de Contratos com TAGs**
- Modelos personalizáveis
- 13 TAGs dinâmicas
- Geração automática
- Sistema de substituição inteligente

### Frontend (Bootstrap 5 / JavaScript ES6)

✅ **Design Responsivo e Moderno**
- Tema azul neutro profissional
- Sidebar retrátil para mobile
- Cards com efeitos e animações
- Tabelas responsivas
- Modals funcionais

✅ **7 Páginas Funcionais**
1. **Login** - Autenticação limpa e segura
2. **Dashboard** - KPIs e gráfico de 12 meses
3. **Lançamentos** - CRUD completo com filtros
4. **Categorias** - Gestão com cores personalizadas
5. **Contas** - A pagar/receber com status
6. **Clientes** - Cadastro detalhado
7. **Contratos** - Modelos e geração

### Banco de Dados

✅ **8 Tabelas Estruturadas**
- empresas (multi-empresa)
- usuarios (autenticação)
- clientes (completo)
- categorias_financeiras
- lancamentos_financeiros
- contas (a pagar/receber)
- contratos_modelos
- contratos_gerados

### Segurança Implementada

✅ **Boas Práticas**
- Senhas com `password_hash()`
- Proteção SQL Injection (PDO)
- Validação de dados
- Sessões seguras
- Headers de segurança

## 🎯 Funcionalidades Principais

### 1. Dashboard Financeiro
- Total de entradas do mês
- Total de saídas do mês
- Saldo atual
- Gráfico de faturamento (12 meses)

### 2. Lançamentos Financeiros
- Cadastro rápido de entrada/saída
- Categorização
- Múltiplas formas de pagamento
- Filtros por período e tipo
- Visualização em tempo real

### 3. Contas a Pagar/Receber
- Controle de vencimentos
- Status automático (pendente/pago/atrasado)
- Filtros por tipo e status
- Vinculação com clientes

### 4. Sistema de Contratos
- Editor de modelos HTML
- TAGs dinâmicas disponíveis:
  - {{nome}}, {{cpf}}, {{cnpj}}, {{cpf_cnpj}}
  - {{endereco}}, {{cidade}}, {{estado}}
  - {{telefone}}, {{email}}
  - {{valor}}, {{descricao_servico}}
  - {{data_atual}}, {{data_validade}}
- Geração automática
- Prévia e impressão

## 🔧 Estrutura de Arquivos

```
maxedr10/
├── api/                         # APIs REST
│   ├── auth/                   # Autenticação
│   ├── lancamentos/            # Lançamentos
│   ├── categorias/             # Categorias
│   ├── contas/                 # Contas
│   ├── clientes/               # Clientes
│   ├── contratos/              # Contratos
│   └── dashboard/              # Dashboard
├── config/                      # Configurações
│   └── config.php              # Config principal
├── database/                    # Banco de dados
│   └── schema.sql              # Schema completo
├── public/                      # Frontend
│   ├── assets/css/             # Estilos
│   ├── includes/               # Header, Sidebar, Footer
│   ├── *.php                   # Páginas do sistema
│   └── .htaccess               # Configuração Apache
├── src/                         # Classes PHP
│   ├── Database/               # Conexão PDO
│   ├── Models/                 # Models (7 classes)
│   └── autoload.php            # Autoloader
└── README.md                    # Documentação
```

## 📱 Responsividade

✅ **Mobile-First**
- Menu hambúrguer
- Cards empilhados
- Tabelas com scroll
- Formulários adaptados
- Touch-friendly

## 🌐 APIs Disponíveis

### Autenticação
- POST `/api/auth/login.php`
- POST `/api/auth/logout.php`
- GET `/api/auth/me.php`

### Lançamentos
- GET/POST `/api/lancamentos/index.php`
- PUT/DELETE `/api/lancamentos/index.php?id=X`

### Categorias
- GET/POST `/api/categorias/index.php`
- PUT/DELETE `/api/categorias/index.php?id=X`

### Contas
- GET/POST `/api/contas/index.php`
- PUT/DELETE `/api/contas/index.php?id=X`

### Clientes
- GET/POST `/api/clientes/index.php`
- PUT/DELETE `/api/clientes/index.php?id=X`

### Contratos
- GET/POST `/api/contratos/modelos.php`
- POST `/api/contratos/gerar.php`

### Dashboard
- GET `/api/dashboard/resumo.php`

## 🎨 Personalização

### Cores do Tema
Edite `public/assets/css/style.css`:

```css
:root {
    --primary: #4a90e2;      /* Azul principal */
    --primary-dark: #357abd;  /* Azul escuro */
    --primary-light: #6ba3e8; /* Azul claro */
}
```

## 📊 Próximos Passos Sugeridos

1. **Geração de PDF** - Implementar biblioteca para PDFs reais
2. **Relatórios** - Adicionar exportação Excel/PDF
3. **E-mails** - Envio de contratos e notificações
4. **Multi-empresas** - Ativar sistema SaaS completo
5. **Permissões** - Sistema de roles e permissões
6. **API JWT** - Autenticação para integrações
7. **Backup** - Sistema automático de backup
8. **Logs** - Auditoria de ações

## ✅ Checklist de Instalação

- [ ] PHP 8+ instalado
- [ ] MySQL 5.7+ instalado
- [ ] Banco `maxedr10` criado
- [ ] Schema importado
- [ ] `config/config.php` configurado
- [ ] URLs ajustadas corretamente
- [ ] Servidor web rodando
- [ ] Acesso ao sistema funcionando

## 🆘 Problemas Comuns

**Erro de conexão MySQL:**
- Verifique credenciais em `config/config.php`
- Confirme que o MySQL está rodando

**Erro 404 nas páginas:**
- Ajuste `BASE_URL` em `config/config.php`
- Verifique o caminho correto no servidor

**APIs não funcionam:**
- Ajuste `API_URL` em `config/config.php`
- Verifique permissões de arquivos

## 📞 Suporte

Sistema desenvolvido como template profissional de ERP.
Totalmente funcional e pronto para uso!

---

**MAXEDR10 - Sistema de Gestão Empresarial**
Desenvolvido com PHP 8+, MySQL, Bootstrap 5 e muito ☕
